unit Unit1;

interface

uses
  Windows, Buttons, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm1 = class(TForm)
  private
    procedure DesenhaTitulo(Ativo : Boolean);
    procedure WMNCPaint(var Msg : TWMNCPaint); message WM_NCPaint;
    procedure WMNCActivate(var Msg : TWMNCActivate); message WM_NCACTIVATE;
    procedure WMSetText(var Msg : TWMSetText); message WM_SETTEXT;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DesenhaTitulo;
var
  xPos, yPos : Integer;
  R : TRect;
  Canvas : TCanvas;
begin
// pega posio de desenho
// frame + botao
  xPos := GetSystemMetrics(SM_CXFRAME) +
    GetSystemMetrics(SM_CXSIZE)+ 2;
  yPos := GetSystemMetrics(SM_CYFRAME) + 2;
  R.Left := xPos;
  R.Top := yPos;

// pega exteses do retngulo de desenho
  R.Right := Width - 3*GetSystemMetrics(SM_CXSIZE) -
    2*GetSystemMetrics(SM_CXFRAME);
  R.Bottom := GetSystemMetrics(SM_CYSIZE);

// cria o canvas de desenho
  Canvas := TCanvas.Create;
  Canvas.Handle := GetWindowDC(Self.Handle);
  try
// seta o fonte do ttulo
    Canvas.Font.Name := 'Arial';
    Canvas.Font.Color := GetSysColor(COLOR_CAPTIONTEXT);
    Canvas.Font.Style := [fsBold,fsItalic];
    if Ativo then
      Canvas.Brush.Color :=
        GetSysColor(COLOR_ACTIVECAPTION)
    else
      Canvas.Brush.Color :=
        GetSysColor(COLOR_INACTIVECAPTION);
    FillRect(Canvas.Handle,R,Canvas.Brush.Color);    
    DrawText(Canvas.Handle, PChar(Caption), -1, R, DT_LEFT );
  finally
    ReleaseDC(Self.Handle, Canvas.Handle);
    Canvas.Handle := 0;
  end;
end;

procedure TForm1.WMNCPaint(var Msg : TWMNCPaint);
begin
  inherited;
  DesenhaTitulo(Active);
end;

procedure TForm1.WMNCActivate(var Msg : TWMNCActivate);
begin
  inherited;
  DesenhaTitulo(Msg.Active);
end;

procedure TForm1.WMSetText(var Msg : TWMSetText);
begin
  inherited;
  DesenhaTitulo(Active);
end;

end.
